(* simplified lexical structure of make(1) language
   copyright (C) 2002 Graydon Hoare <graydon@pobox.com>
   GPL 2.x+ no warranty provided or implied *)

{
  open Lexing
  open String
}

let special = ['$' '@' '<' '^' '(' ')' '=' ':' '%']
let nq = ("\\\""|[^'"'])
let sym = ['-' '_' '.' '/' '*' 'a'-'z''A'-'Z''0'-'9']*

rule token = parse
    ' '*  { token lexbuf }
  | ('#' [^'\n']*)? ('\n'+) { ("EOL", "") }
  | '\t'       { ("TAB", "") }
  | eof        { ("EOF", "") }
  | (sym | '"' nq* '"') { ("WORD",   lexeme lexbuf) }
  | special { ("", lexeme lexbuf)}
  | _       { ("", lexeme lexbuf) }
